/**********************************************
 *							                  *
 * ļ: 06 Ͷ\02 BinaryTree      *
 * 							                  *
 * ļ: BinaryTree.h                       *
 *    	    				                  *
 *   : 洢زб *
 *                                            *
 **********************************************/
 
#ifndef BINARYTREE_H
#define BINARYTREE_H

#include <stdio.h>
#include <stdlib.h>								//ṩmallocreallocfreeexitԭ
#include <math.h>								//ṩpowlogԭ 
#include "../../01 /Status.h"				//**01 **//
#include "../../01 /Scanf.c"				//**01 **//

/* 洢Ͷ */
typedef char TElemType;							//ԪؾΪַ
typedef struct BiTNode
{
	TElemType data;								//Ԫ 
	struct BiTNode* lchild;						//ָ 
	struct BiTNode* rchild;						//Һָ 
}BiTNode;										// 
typedef BiTNode* BiTree;						//ָָ

/* ջԪ */
typedef BiTree SElemType_Sq;					//ضջԪ 
#include "../../03 ջͶ/01 SequenceStack/SequenceStack.c"	//**03 ջͶ**// 

/* 洢ǰϢ */
/* ڰṹӡʱʹ */ 
typedef struct									
{ 
	BiTree left;								//ǰָ 
	BiTree right;								//ǰָ 
	int n;										//ǰĴ 
}Node;

/* 洢  */
void InitBiTree(BiTree *T);
/*
(01)նT (ʼ)
*/

void ClearBiTree(BiTree *T);
/*
(02)նT 
*/

void DestroyBiTree(BiTree *T);
/*
(03)ٶT 
*/

Status BiTreeEmpty(BiTree T);
/*
(04)ж϶TǷΪա 
*/

Status CreateBiTree(FILE *fp, BiTree *T);
/*
(05)㷨6.4й 
*/

int BiTreeLength(BiTree T);
/*
(06)ضȣȫ㣩
*/

int BiTreeDepth(BiTree T);
/*
(07)ضȣ
*/

Status Root(BiTree T, TElemType *e);
/*
(08)eضĸֵ 
*/

TElemType Value(BiTree p);
/*
(09)ĳֵpΪָ롣 
*/

void Assign(BiTree p, TElemType value);
/*
(10)Ϊĳ㸳ֵpΪָ롣 
*/            

TElemType Parent(BiTree T, TElemType e);
/*
(11)ĳ˫׽ֵ
*/

TElemType LeftChild(BiTree T, TElemType e);
/*
(12)ĳӽֵ
*/

TElemType RightChild(BiTree T, TElemType e);
/*
(13)ĳҺӽֵ
*/

TElemType LeftSibling(BiTree T, TElemType e);
/*
(14)ĳֵֵܽ
*/

TElemType RightSibling(BiTree T, TElemType e);
/*
(15)ĳֵֵܽ
*/

BiTree LocationBiTree_1(BiTree T, TElemType e); 
/*
(16-1)ȡָeָ롣 
*/

BiTree LocationBiTree_2(BiTree T, TElemType e); 
/*
(16-2)ȡָeָ롣 
*/

Status InsertBiTree(BiTree T, TElemType e, BiTree T0, int LR);
/*
(17)T0뵽TгΪeLRΪǣT0ֻ
*/

Status DeleteBiTree(BiTree T, TElemType e, int LR);
/*
(18)ɾeLRΪɾǡ 
*/

void LevelOrderTraverse(BiTree T, void(Visit)(TElemType));
/*
(19)
*/

void PreOrderTraverse_1(BiTree T, void(Visit)(TElemType));
/*
(20-1)
*/

Status PreOrderTraverse_2(BiTree T, Status(Visit)(TElemType));
/*
(20-2)㷨6.1 
*/

void InOrderTraverse_1(BiTree T, void(Visit)(TElemType));
/*
(21-1)
*/

Status InOrderTraverse_2(BiTree T, Status(Visit)(TElemType)); 
/*
(21-2)㷨6.2 
*/

Status InOrderTraverse_3(BiTree T, Status(Visit)(TElemType));
/*
(21-3)㷨6.3 
*/

void PostOrderTraverse(BiTree T, void(Visit)(TElemType));
/*
(22)
*/

void PrintTree(BiTree T);
/*
(23)Ľṹӡ
*/

#endif
